import { jsx } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import { useActions } from "../../context/actions.mjs";
import { TldrawUiMenuItem } from "../primitives/menus/TldrawUiMenuItem.mjs";
function ExitPenMode() {
  const editor = useEditor();
  const actions = useActions();
  const isPenMode = useValue("is pen mode", () => editor.getInstanceState().isPenMode, [editor]);
  if (!isPenMode) return null;
  return /* @__PURE__ */ jsx(TldrawUiMenuItem, { ...actions["exit-pen-mode"] });
}
export {
  ExitPenMode
};
//# sourceMappingURL=ExitPenMode.mjs.map
